<?php 
session_start();
if(!isset($_SESSION['username'])){
    header("location: login.php");
} else {
?>
<?php include("includes/header.php"); ?>
<div id="content-wrapper">

  <div class="container-fluid">

    <!-- Breadcrumbs-->
    <ol class="breadcrumb">
      <li class="breadcrumb-item">
        <a href="#">Dashboard</a>
      </li>
      <li class="breadcrumb-item active">Overview</li>
    </ol>

    <!-- Data Table -->
    <div class="card mb-3">
      <div class="card-header">
        <i class="fas fa-table"></i>
        View All Records (n_2)</div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
            <thead>
              <tr>
                <th>id</th>
                <?php 
                // generate headers COL_2 -> COL_43
                for ($i=2; $i<=43; $i++) {
                    echo "<th>COL_$i</th>";
                }
                ?>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
<?php
// get Values from db
include("includes/db.php");

// prepare query to select needed columns
$cols = "id";
for ($i=2; $i<=43; $i++) {
    $cols .= ", `COL_$i`";
}

$stmt = $mysqli->prepare("SELECT $cols FROM n_2");
$stmt->execute();
$res = $stmt->get_result();

while($row = $res->fetch_assoc()){
    echo "<tr>";
    echo "<td>".$row['id']."</td>";
    for ($i=2; $i<=43; $i++) {
        echo "<td>".$row["COL_$i"]."</td>";
    }
    // زر التعديل والحذف
    echo "<td>
            <a href='edit.php?id=".$row['id']."' class='btn btn-sm btn-primary'>تعديل</a>
            <a href='delete.php?id=".$row['id']."' class='btn btn-sm btn-danger' onclick=\"return confirm('هل انت متأكد من الحذف؟');\">حذف</a>
          </td>";
    echo "</tr>";
}
?>    
            </tbody>
          </table>
        </div>
      </div>
      <div class="card-footer small text-muted">Updated automatically</div>
    </div>
  </div>
  <!-- /.container-fluid -->

<?php include("includes/footer.php"); } ?>
